DROP TABLESPACE SYSTEM INCLUDING CONTENTS AND DATAFILES;

CREATE TABLESPACE SYSTEM DATAFILE 
  '+DATA_1/adry/system' SIZE 710M AUTOEXTEND ON NEXT 10M MAXSIZE 4G
LOGGING
ONLINE
EXTENT MANAGEMENT LOCAL AUTOALLOCATE
BLOCKSIZE 8K
FLASHBACK ON;
DROP TABLESPACE UNDOTBS1 INCLUDING CONTENTS AND DATAFILES;

CREATE UNDO TABLESPACE UNDOTBS1 DATAFILE 
  '+UNDO_TEMP_1/adry/undo1_01' SIZE 27776M AUTOEXTEND ON NEXT 128M MAXSIZE 32767M
ONLINE
RETENTION NOGUARANTEE
BLOCKSIZE 8K
FLASHBACK ON;
DROP TABLESPACE SYSAUX INCLUDING CONTENTS AND DATAFILES;

CREATE TABLESPACE SYSAUX DATAFILE 
  '+DATA_1/adry/sysaux' SIZE 9830M AUTOEXTEND ON NEXT 10M MAXSIZE 12000M
LOGGING
ONLINE
EXTENT MANAGEMENT LOCAL AUTOALLOCATE
BLOCKSIZE 8K
SEGMENT SPACE MANAGEMENT AUTO
FLASHBACK ON;
DROP TABLESPACE TEMP INCLUDING CONTENTS AND DATAFILES;

CREATE TEMPORARY TABLESPACE TEMP TEMPFILE 
  '+UNDO_TEMP_1/adry/temp_01' SIZE 32767M AUTOEXTEND ON NEXT 640K MAXSIZE 32767M
TABLESPACE GROUP ''
EXTENT MANAGEMENT LOCAL UNIFORM SIZE 1M;
DROP TABLESPACE UNDOTBS2 INCLUDING CONTENTS AND DATAFILES;

CREATE UNDO TABLESPACE UNDOTBS2 DATAFILE 
  '+UNDO_TEMP_1/adry/undo2_01' SIZE 20992M AUTOEXTEND ON NEXT 128M MAXSIZE 32767M
ONLINE
RETENTION NOGUARANTEE
BLOCKSIZE 8K
FLASHBACK ON;
DROP TABLESPACE UNDOTBS3 INCLUDING CONTENTS AND DATAFILES;

CREATE UNDO TABLESPACE UNDOTBS3 DATAFILE 
  '+UNDO_TEMP_1/adry/undo3_01' SIZE 18304M AUTOEXTEND ON NEXT 128M MAXSIZE 32767M
ONLINE
RETENTION NOGUARANTEE
BLOCKSIZE 8K
FLASHBACK ON;
DROP TABLESPACE USERS INCLUDING CONTENTS AND DATAFILES;

CREATE TABLESPACE USERS DATAFILE 
  '+DATA_1/adry/users' SIZE 37120K AUTOEXTEND ON NEXT 1280K MAXSIZE 4G
LOGGING
ONLINE
EXTENT MANAGEMENT LOCAL AUTOALLOCATE
BLOCKSIZE 8K
SEGMENT SPACE MANAGEMENT AUTO
FLASHBACK ON;
DROP TABLESPACE AUDIT_01 INCLUDING CONTENTS AND DATAFILES;

CREATE TABLESPACE AUDIT_01 DATAFILE 
  '+DATA_1/adry/audit_01_01' SIZE 896M AUTOEXTEND ON NEXT 128M MAXSIZE 4G
LOGGING
ONLINE
EXTENT MANAGEMENT LOCAL UNIFORM SIZE 4M
BLOCKSIZE 8K
SEGMENT SPACE MANAGEMENT AUTO
FLASHBACK ON;
DROP TABLESPACE S_DATA_01 INCLUDING CONTENTS AND DATAFILES;

CREATE TABLESPACE S_DATA_01 DATAFILE 
  '+DATA_1/adry/s_data_01_01' SIZE 19968M AUTOEXTEND ON NEXT 128M MAXSIZE 32767M,
  '+DATA_1/adry/s_data_01_02' SIZE 19200M AUTOEXTEND ON NEXT 128M MAXSIZE 32767M
LOGGING
ONLINE
EXTENT MANAGEMENT LOCAL UNIFORM SIZE 128K
BLOCKSIZE 8K
SEGMENT SPACE MANAGEMENT AUTO
FLASHBACK ON;
DROP TABLESPACE S_INDEX_01 INCLUDING CONTENTS AND DATAFILES;

CREATE TABLESPACE S_INDEX_01 DATAFILE 
  '+INDEX_1/adry/s_index_01_01' SIZE 26240M AUTOEXTEND ON NEXT 128M MAXSIZE 32767M
LOGGING
ONLINE
EXTENT MANAGEMENT LOCAL UNIFORM SIZE 128K
BLOCKSIZE 8K
SEGMENT SPACE MANAGEMENT AUTO
FLASHBACK ON;
DROP TABLESPACE M_DATA_01 INCLUDING CONTENTS AND DATAFILES;

CREATE TABLESPACE M_DATA_01 DATAFILE 
  '+DATA_1/adry/m_data_01_04' SIZE 32767M AUTOEXTEND ON NEXT 512M MAXSIZE 32767M,
  '+DATA_1/adry/m_data_01_01' SIZE 32767M AUTOEXTEND ON NEXT 512M MAXSIZE 32767M,
  '+DATA_1/adry/m_data_01_02' SIZE 32767M AUTOEXTEND ON NEXT 512M MAXSIZE 32767M,
  '+DATA_1/adry/m_data_01_03' SIZE 32767M AUTOEXTEND ON NEXT 512M MAXSIZE 32767M,
  '+DATA_1/adry/m_data_01_05' SIZE 31232M AUTOEXTEND ON NEXT 512M MAXSIZE 32767M
LOGGING
ONLINE
EXTENT MANAGEMENT LOCAL UNIFORM SIZE 4M
BLOCKSIZE 8K
SEGMENT SPACE MANAGEMENT AUTO
FLASHBACK ON;
DROP TABLESPACE M_INDEX_01 INCLUDING CONTENTS AND DATAFILES;

CREATE TABLESPACE M_INDEX_01 DATAFILE 
  '+INDEX_1/adry/m_index_01_10' SIZE 32767M AUTOEXTEND ON NEXT 512M MAXSIZE 32767M,
  '+INDEX_1/adry/m_index_01_01' SIZE 32767M AUTOEXTEND ON NEXT 512M MAXSIZE 32767M,
  '+INDEX_1/adry/m_index_01_02' SIZE 32767M AUTOEXTEND ON NEXT 512M MAXSIZE 32767M,
  '+INDEX_1/adry/m_index_01_03' SIZE 32767M AUTOEXTEND ON NEXT 512M MAXSIZE 32767M,
  '+INDEX_1/adry/m_index_01_04' SIZE 32767M AUTOEXTEND ON NEXT 512M MAXSIZE 32767M,
  '+INDEX_1/adry/m_index_01_05' SIZE 32767M AUTOEXTEND ON NEXT 512M MAXSIZE 32767M,
  '+INDEX_1/adry/m_index_01_06' SIZE 32767M AUTOEXTEND ON NEXT 512M MAXSIZE 32767M,
  '+INDEX_1/adry/m_index_01_07' SIZE 32767M AUTOEXTEND ON NEXT 512M MAXSIZE 32767M,
  '+INDEX_1/adry/m_index_01_08' SIZE 32767M AUTOEXTEND ON NEXT 512M MAXSIZE 32767M,
  '+INDEX_1/adry/m_index_01_09' SIZE 32767M AUTOEXTEND ON NEXT 512M MAXSIZE 32767M,
  '+INDEX_1/adry/m_index_01_11' SIZE 22G AUTOEXTEND ON NEXT 512M MAXSIZE 32767M,
  '+INDEX_1/adry/m_index_01_12' SIZE 13G AUTOEXTEND ON NEXT 512M MAXSIZE 32767M,
  '+INDEX_1/adry/m_index_01_13' SIZE 1G AUTOEXTEND ON NEXT 512M MAXSIZE 32767M
LOGGING
ONLINE
EXTENT MANAGEMENT LOCAL UNIFORM SIZE 4M
BLOCKSIZE 8K
SEGMENT SPACE MANAGEMENT AUTO
FLASHBACK ON;
DROP TABLESPACE L_DATA_01 INCLUDING CONTENTS AND DATAFILES;

CREATE TABLESPACE L_DATA_01 DATAFILE 
  '+DATA_1/adry/l_data_01_12' SIZE 32767M AUTOEXTEND ON NEXT 512M MAXSIZE 32767M,
  '+DATA_1/adry/l_data_01_01' SIZE 32767M AUTOEXTEND ON NEXT 512M MAXSIZE 32767M,
  '+DATA_1/adry/l_data_01_02' SIZE 32767M AUTOEXTEND ON NEXT 512M MAXSIZE 32767M,
  '+DATA_1/adry/l_data_01_03' SIZE 32767M AUTOEXTEND ON NEXT 512M MAXSIZE 32767M,
  '+DATA_1/adry/l_data_01_04' SIZE 32767M AUTOEXTEND ON NEXT 512M MAXSIZE 32767M,
  '+DATA_1/adry/l_data_01_05' SIZE 32767M AUTOEXTEND ON NEXT 512M MAXSIZE 32767M,
  '+DATA_1/adry/l_data_01_06' SIZE 32767M AUTOEXTEND ON NEXT 512M MAXSIZE 32767M,
  '+DATA_1/adry/l_data_01_07' SIZE 32767M AUTOEXTEND ON NEXT 512M MAXSIZE 32767M,
  '+DATA_1/adry/l_data_01_08' SIZE 32767M AUTOEXTEND ON NEXT 512M MAXSIZE 32767M,
  '+DATA_1/adry/l_data_01_09' SIZE 32767M AUTOEXTEND ON NEXT 512M MAXSIZE 32767M,
  '+DATA_1/adry/l_data_01_10' SIZE 32767M AUTOEXTEND ON NEXT 512M MAXSIZE 32767M,
  '+DATA_1/adry/l_data_01_11' SIZE 32767M AUTOEXTEND ON NEXT 512M MAXSIZE 32767M,
  '+DATA_1/adry/l_data_01_13' SIZE 32767M AUTOEXTEND ON NEXT 512M MAXSIZE 32767M,
  '+DATA_1/adry/l_data_01_14' SIZE 32767M AUTOEXTEND ON NEXT 512M MAXSIZE 32767M,
  '+DATA_1/adry/l_data_01_15' SIZE 32767M AUTOEXTEND ON NEXT 512M MAXSIZE 32767M,
  '+DATA_1/adry/l_data_01_16' SIZE 32767M AUTOEXTEND ON NEXT 512M MAXSIZE 32767M,
  '+DATA_1/adry/l_data_01_17' SIZE 32767M AUTOEXTEND ON NEXT 512M MAXSIZE 32767M,
  '+DATA_1/adry/l_data_01_18' SIZE 32767M AUTOEXTEND ON NEXT 512M MAXSIZE 32767M,
  '+DATA_1/adry/l_data_01_19' SIZE 32767M AUTOEXTEND ON NEXT 512M MAXSIZE 32767M,
  '+DATA_1/adry/l_data_01_20' SIZE 32767M AUTOEXTEND ON NEXT 512M MAXSIZE 32767M,
  '+DATA_1/adry/l_data_01_21' SIZE 32767M AUTOEXTEND ON NEXT 512M MAXSIZE 32767M,
  '+DATA_1/adry/l_data_01_22' SIZE 32767M AUTOEXTEND ON NEXT 512M MAXSIZE 32767M,
  '+DATA_1/adry/l_data_01_23' SIZE 32767M AUTOEXTEND ON NEXT 512M MAXSIZE 32767M,
  '+DATA_1/adry/l_data_01_24' SIZE 32767M AUTOEXTEND ON NEXT 512M MAXSIZE 32767M,
  '+DATA_1/adry/l_data_01_25' SIZE 32767M AUTOEXTEND ON NEXT 512M MAXSIZE 32767M,
  '+DATA_1/adry/l_data_01_26' SIZE 32767M AUTOEXTEND ON NEXT 512M MAXSIZE 32767M,
  '+DATA_1/adry/l_data_01_27' SIZE 32767M AUTOEXTEND ON NEXT 512M MAXSIZE 32767M,
  '+DATA_1/adry/l_data_01_28' SIZE 32767M AUTOEXTEND ON NEXT 512M MAXSIZE 32767M,
  '+DATA_1/adry/l_data_01_29' SIZE 32767M AUTOEXTEND ON NEXT 512M MAXSIZE 32767M,
  '+DATA_1/adry/l_data_01_30' SIZE 32767M AUTOEXTEND ON NEXT 512M MAXSIZE 32767M,
  '+DATA_1/adry/l_data_01_31' SIZE 26G AUTOEXTEND ON NEXT 512M MAXSIZE 32767M,
  '+DATA_1/adry/l_data_01_32' SIZE 26112M AUTOEXTEND ON NEXT 512M MAXSIZE 32767M,
  '+DATA_1/adry/l_data_01_33' SIZE 17G AUTOEXTEND ON NEXT 512M MAXSIZE 32767M,
  '+DATA_1/adry/l_data_01_34' SIZE 9G AUTOEXTEND ON NEXT 512M MAXSIZE 32767M,
  '+DATA_1/adry/l_data_01_35' SIZE 9G AUTOEXTEND ON NEXT 512M MAXSIZE 32767M,
  '+DATA_1/adry/l_data_01_36' SIZE 9G AUTOEXTEND ON NEXT 512M MAXSIZE 32767M,
  '+DATA_1/adry/l_data_01_37' SIZE 1G AUTOEXTEND ON NEXT 512M MAXSIZE 32767M,
  '+DATA_1/adry/l_data_01_38' SIZE 1G AUTOEXTEND ON NEXT 512M MAXSIZE 32767M,
  '+DATA_1/adry/l_data_01_39' SIZE 1G AUTOEXTEND ON NEXT 512M MAXSIZE 32767M
LOGGING
ONLINE
EXTENT MANAGEMENT LOCAL UNIFORM SIZE 128M
BLOCKSIZE 8K
SEGMENT SPACE MANAGEMENT AUTO
FLASHBACK ON;
DROP TABLESPACE L_INDEX_01 INCLUDING CONTENTS AND DATAFILES;

CREATE TABLESPACE L_INDEX_01 DATAFILE 
  '+INDEX_1/adry/l_index_01_01' SIZE 32767M AUTOEXTEND ON NEXT 512M MAXSIZE 32767M,
  '+INDEX_1/adry/l_index_01_02' SIZE 32767M AUTOEXTEND ON NEXT 512M MAXSIZE 32767M,
  '+INDEX_1/adry/l_index_01_03' SIZE 32767M AUTOEXTEND ON NEXT 512M MAXSIZE 32767M,
  '+INDEX_1/adry/l_index_01_04' SIZE 32767M AUTOEXTEND ON NEXT 512M MAXSIZE 32767M,
  '+INDEX_1/adry/l_index_01_05' SIZE 32767M AUTOEXTEND ON NEXT 512M MAXSIZE 32767M,
  '+INDEX_1/adry/l_index_01_06' SIZE 32767M AUTOEXTEND ON NEXT 512M MAXSIZE 32767M,
  '+INDEX_1/adry/l_index_01_07' SIZE 32767M AUTOEXTEND ON NEXT 512M MAXSIZE 32767M,
  '+INDEX_1/adry/l_index_01_08' SIZE 31232M AUTOEXTEND ON NEXT 512M MAXSIZE 32767M,
  '+INDEX_1/adry/l_index_01_09' SIZE 16896M AUTOEXTEND ON NEXT 512M MAXSIZE 32767M,
  '+INDEX_1/adry/l_index_01_10' SIZE 1G AUTOEXTEND ON NEXT 512M MAXSIZE 32767M,
  '+INDEX_1/adry/l_index_01_11' SIZE 1G AUTOEXTEND ON NEXT 512M MAXSIZE 32767M
LOGGING
ONLINE
EXTENT MANAGEMENT LOCAL UNIFORM SIZE 128M
BLOCKSIZE 8K
SEGMENT SPACE MANAGEMENT AUTO
FLASHBACK ON;
DROP TABLESPACE L_DATA_02_P01 INCLUDING CONTENTS AND DATAFILES;

CREATE TABLESPACE L_DATA_02_P01 DATAFILE 
  '+DATA_1/adry/l_data_02_p01_04' SIZE 25G AUTOEXTEND ON NEXT 512M MAXSIZE 32767M,
  '+DATA_1/adry/l_data_02_p01_01' SIZE 32767M AUTOEXTEND ON NEXT 512M MAXSIZE 32767M,
  '+DATA_1/adry/l_data_02_p01_02' SIZE 32767M AUTOEXTEND ON NEXT 512M MAXSIZE 32767M,
  '+DATA_1/adry/l_data_02_p01_03' SIZE 32767M AUTOEXTEND ON NEXT 512M MAXSIZE 32767M,
  '+DATA_1/adry/l_data_02_p01_05' SIZE 6656M AUTOEXTEND ON NEXT 512M MAXSIZE 32767M
LOGGING
ONLINE
EXTENT MANAGEMENT LOCAL UNIFORM SIZE 128M
BLOCKSIZE 8K
SEGMENT SPACE MANAGEMENT AUTO
FLASHBACK ON;
DROP TABLESPACE L_DATA_02_P02 INCLUDING CONTENTS AND DATAFILES;

CREATE TABLESPACE L_DATA_02_P02 DATAFILE 
  '+DATA_1/adry/l_data_02_p02_01' SIZE 32767M AUTOEXTEND ON NEXT 512M MAXSIZE 32767M,
  '+DATA_1/adry/l_data_02_p02_02' SIZE 32767M AUTOEXTEND ON NEXT 512M MAXSIZE 32767M,
  '+DATA_1/adry/l_data_02_p02_03' SIZE 32767M AUTOEXTEND ON NEXT 512M MAXSIZE 32767M,
  '+DATA_1/adry/l_data_02_p02_04' SIZE 23040M AUTOEXTEND ON NEXT 512M MAXSIZE 32767M,
  '+DATA_1/adry/l_data_02_p02_05' SIZE 1G AUTOEXTEND ON NEXT 512M MAXSIZE 32767M
LOGGING
ONLINE
EXTENT MANAGEMENT LOCAL UNIFORM SIZE 128M
BLOCKSIZE 8K
SEGMENT SPACE MANAGEMENT AUTO
FLASHBACK ON;
DROP TABLESPACE L_DATA_02_P03 INCLUDING CONTENTS AND DATAFILES;

CREATE TABLESPACE L_DATA_02_P03 DATAFILE 
  '+DATA_1/adry/l_data_02_p03_01' SIZE 32767M AUTOEXTEND ON NEXT 512M MAXSIZE 32767M,
  '+DATA_1/adry/l_data_02_p03_02' SIZE 32767M AUTOEXTEND ON NEXT 512M MAXSIZE 32767M,
  '+DATA_1/adry/l_data_02_p03_03' SIZE 32767M AUTOEXTEND ON NEXT 512M MAXSIZE 32767M,
  '+DATA_1/adry/l_data_02_p03_04' SIZE 23G AUTOEXTEND ON NEXT 512M MAXSIZE 32767M,
  '+DATA_1/adry/l_data_02_p03_05' SIZE 1G AUTOEXTEND ON NEXT 512M MAXSIZE 32767M
LOGGING
ONLINE
EXTENT MANAGEMENT LOCAL UNIFORM SIZE 128M
BLOCKSIZE 8K
SEGMENT SPACE MANAGEMENT AUTO
FLASHBACK ON;
DROP TABLESPACE L_DATA_02_P04 INCLUDING CONTENTS AND DATAFILES;

CREATE TABLESPACE L_DATA_02_P04 DATAFILE 
  '+DATA_1/adry/l_data_02_p04_01' SIZE 32767M AUTOEXTEND ON NEXT 512M MAXSIZE 32767M,
  '+DATA_1/adry/l_data_02_p04_02' SIZE 32767M AUTOEXTEND ON NEXT 512M MAXSIZE 32767M,
  '+DATA_1/adry/l_data_02_p04_03' SIZE 32767M AUTOEXTEND ON NEXT 512M MAXSIZE 32767M,
  '+DATA_1/adry/l_data_02_p04_04' SIZE 21G AUTOEXTEND ON NEXT 512M MAXSIZE 32767M,
  '+DATA_1/adry/l_data_02_p04_05' SIZE 3584M AUTOEXTEND ON NEXT 512M MAXSIZE 32767M
LOGGING
ONLINE
EXTENT MANAGEMENT LOCAL UNIFORM SIZE 128M
BLOCKSIZE 8K
SEGMENT SPACE MANAGEMENT AUTO
FLASHBACK ON;
DROP TABLESPACE L_INDEX_02_P01 INCLUDING CONTENTS AND DATAFILES;

CREATE TABLESPACE L_INDEX_02_P01 DATAFILE 
  '+INDEX_1/adry/l_index_02_p01_04' SIZE 32767M AUTOEXTEND ON NEXT 512M MAXSIZE 32767M,
  '+INDEX_1/adry/l_index_02_p01_05' SIZE 32767M AUTOEXTEND ON NEXT 512M MAXSIZE 32767M,
  '+INDEX_1/adry/l_index_02_p01_01' SIZE 32767M AUTOEXTEND ON NEXT 512M MAXSIZE 32767M,
  '+INDEX_1/adry/l_index_02_p01_02' SIZE 32767M AUTOEXTEND ON NEXT 512M MAXSIZE 32767M,
  '+INDEX_1/adry/l_index_02_p01_03' SIZE 32767M AUTOEXTEND ON NEXT 512M MAXSIZE 32767M,
  '+INDEX_1/adry/l_index_02_p01_06' SIZE 32767M AUTOEXTEND ON NEXT 512M MAXSIZE 32767M,
  '+INDEX_1/adry/l_index_02_p01_07' SIZE 19968M AUTOEXTEND ON NEXT 512M MAXSIZE 32767M,
  '+INDEX_1/adry/l_index_02_p01_08' SIZE 5632M AUTOEXTEND ON NEXT 512M MAXSIZE 32767M
LOGGING
ONLINE
EXTENT MANAGEMENT LOCAL UNIFORM SIZE 128M
BLOCKSIZE 8K
SEGMENT SPACE MANAGEMENT AUTO
FLASHBACK ON;
DROP TABLESPACE L_INDEX_02_P02 INCLUDING CONTENTS AND DATAFILES;

CREATE TABLESPACE L_INDEX_02_P02 DATAFILE 
  '+INDEX_1/adry/l_index_02_p02_03' SIZE 32767M AUTOEXTEND ON NEXT 512M MAXSIZE 32767M,
  '+INDEX_1/adry/l_index_02_p02_01' SIZE 32767M AUTOEXTEND ON NEXT 512M MAXSIZE 32767M,
  '+INDEX_1/adry/l_index_02_p02_02' SIZE 32767M AUTOEXTEND ON NEXT 512M MAXSIZE 32767M,
  '+INDEX_1/adry/l_index_02_p02_04' SIZE 27136M AUTOEXTEND ON NEXT 512M MAXSIZE 32767M,
  '+INDEX_1/adry/l_index_02_p02_05' SIZE 8G AUTOEXTEND ON NEXT 512M MAXSIZE 32767M
LOGGING
ONLINE
EXTENT MANAGEMENT LOCAL UNIFORM SIZE 128M
BLOCKSIZE 8K
SEGMENT SPACE MANAGEMENT AUTO
FLASHBACK ON;
DROP TABLESPACE L_INDEX_02_P03 INCLUDING CONTENTS AND DATAFILES;

CREATE TABLESPACE L_INDEX_02_P03 DATAFILE 
  '+INDEX_1/adry/l_index_02_p03_03' SIZE 32767M AUTOEXTEND ON NEXT 512M MAXSIZE 32767M,
  '+INDEX_1/adry/l_index_02_p03_01' SIZE 32767M AUTOEXTEND ON NEXT 512M MAXSIZE 32767M,
  '+INDEX_1/adry/l_index_02_p03_02' SIZE 32767M AUTOEXTEND ON NEXT 512M MAXSIZE 32767M,
  '+INDEX_1/adry/l_index_02_p03_04' SIZE 27G AUTOEXTEND ON NEXT 512M MAXSIZE 32767M,
  '+INDEX_1/adry/l_index_02_p03_05' SIZE 4G AUTOEXTEND ON NEXT 512M MAXSIZE 32767M
LOGGING
ONLINE
EXTENT MANAGEMENT LOCAL UNIFORM SIZE 128M
BLOCKSIZE 8K
SEGMENT SPACE MANAGEMENT AUTO
FLASHBACK ON;
DROP TABLESPACE L_INDEX_02_P04 INCLUDING CONTENTS AND DATAFILES;

CREATE TABLESPACE L_INDEX_02_P04 DATAFILE 
  '+INDEX_1/adry/l_index_02_p04_03' SIZE 32767M AUTOEXTEND ON NEXT 512M MAXSIZE 32767M,
  '+INDEX_1/adry/l_index_02_p04_04' SIZE 29184M AUTOEXTEND ON NEXT 512M MAXSIZE 32767M,
  '+INDEX_1/adry/l_index_02_p04_01' SIZE 32767M AUTOEXTEND ON NEXT 512M MAXSIZE 32767M,
  '+INDEX_1/adry/l_index_02_p04_02' SIZE 32767M AUTOEXTEND ON NEXT 512M MAXSIZE 32767M,
  '+INDEX_1/adry/l_index_02_p04_05' SIZE 7G AUTOEXTEND ON NEXT 512M MAXSIZE 32767M
LOGGING
ONLINE
EXTENT MANAGEMENT LOCAL UNIFORM SIZE 128M
BLOCKSIZE 8K
SEGMENT SPACE MANAGEMENT AUTO
FLASHBACK ON;
DROP TABLESPACE S_IDH_DATA_01 INCLUDING CONTENTS AND DATAFILES;

CREATE TABLESPACE S_IDH_DATA_01 DATAFILE 
  '+DATA_1/adry/s_idh_data_01_01' SIZE 14848M AUTOEXTEND ON NEXT 512M MAXSIZE 32767M
LOGGING
ONLINE
EXTENT MANAGEMENT LOCAL UNIFORM SIZE 128K
BLOCKSIZE 8K
SEGMENT SPACE MANAGEMENT AUTO
FLASHBACK ON;
DROP TABLESPACE S_IDH_INDEX_01 INCLUDING CONTENTS AND DATAFILES;

CREATE TABLESPACE S_IDH_INDEX_01 DATAFILE 
  '+INDEX_1/adry/s_idh_index_01_01' SIZE 512M AUTOEXTEND ON NEXT 512M MAXSIZE 32767M
LOGGING
ONLINE
EXTENT MANAGEMENT LOCAL UNIFORM SIZE 128K
BLOCKSIZE 8K
SEGMENT SPACE MANAGEMENT AUTO
FLASHBACK ON;
DROP TABLESPACE M_IDH_DATA_01 INCLUDING CONTENTS AND DATAFILES;

CREATE TABLESPACE M_IDH_DATA_01 DATAFILE 
  '+DATA_1/adry/m_idh_data_01_01' SIZE 12G AUTOEXTEND ON NEXT 512M MAXSIZE 32767M
LOGGING
ONLINE
EXTENT MANAGEMENT LOCAL UNIFORM SIZE 4M
BLOCKSIZE 8K
SEGMENT SPACE MANAGEMENT AUTO
FLASHBACK ON;
DROP TABLESPACE M_IDH_INDEX_01 INCLUDING CONTENTS AND DATAFILES;

CREATE TABLESPACE M_IDH_INDEX_01 DATAFILE 
  '+INDEX_1/adry/m_idh_index_01_01' SIZE 14848M AUTOEXTEND ON NEXT 512M MAXSIZE 32767M
LOGGING
ONLINE
EXTENT MANAGEMENT LOCAL UNIFORM SIZE 4M
BLOCKSIZE 8K
SEGMENT SPACE MANAGEMENT AUTO
FLASHBACK ON;
DROP TABLESPACE L_IDH_DATA_01 INCLUDING CONTENTS AND DATAFILES;

CREATE TABLESPACE L_IDH_DATA_01 DATAFILE 
  '+DATA_1/adry/l_idh_data_01_01' SIZE 32767M AUTOEXTEND ON NEXT 512M MAXSIZE 32767M,
  '+DATA_1/adry/l_idh_data_01_02' SIZE 32767M AUTOEXTEND ON NEXT 512M MAXSIZE 32767M,
  '+DATA_1/adry/l_idh_data_01_03' SIZE 25G AUTOEXTEND ON NEXT 512M MAXSIZE 32767M
LOGGING
ONLINE
EXTENT MANAGEMENT LOCAL UNIFORM SIZE 128M
BLOCKSIZE 8K
SEGMENT SPACE MANAGEMENT AUTO
FLASHBACK ON;
DROP TABLESPACE L_IDH_INDEX_01 INCLUDING CONTENTS AND DATAFILES;

CREATE TABLESPACE L_IDH_INDEX_01 DATAFILE 
  '+INDEX_1/adry/l_idh_index_01_01' SIZE 32767M AUTOEXTEND ON NEXT 512M MAXSIZE 32767M,
  '+INDEX_1/adry/l_idh_index_01_02' SIZE 24G AUTOEXTEND ON NEXT 512M MAXSIZE 32767M
LOGGING
ONLINE
EXTENT MANAGEMENT LOCAL UNIFORM SIZE 128M
BLOCKSIZE 8K
SEGMENT SPACE MANAGEMENT AUTO
FLASHBACK ON;
DROP TABLESPACE L_VOA_DATA_01 INCLUDING CONTENTS AND DATAFILES;

CREATE TABLESPACE L_VOA_DATA_01 DATAFILE 
  '+DATA_1/adry/l_voa_data_01_01' SIZE 4G AUTOEXTEND ON NEXT 512M MAXSIZE 32767M
LOGGING
ONLINE
EXTENT MANAGEMENT LOCAL UNIFORM SIZE 128M
BLOCKSIZE 8K
SEGMENT SPACE MANAGEMENT AUTO
FLASHBACK ON;
DROP TABLESPACE L_VOA_INDEX_01 INCLUDING CONTENTS AND DATAFILES;

CREATE TABLESPACE L_VOA_INDEX_01 DATAFILE 
  '+INDEX_1/adry/l_voa_index_01_01' SIZE 512M AUTOEXTEND ON NEXT 512M MAXSIZE 32767M
LOGGING
ONLINE
EXTENT MANAGEMENT LOCAL UNIFORM SIZE 128M
BLOCKSIZE 8K
SEGMENT SPACE MANAGEMENT AUTO
FLASHBACK ON;
DROP TABLESPACE M_VOA_DATA_01 INCLUDING CONTENTS AND DATAFILES;

CREATE TABLESPACE M_VOA_DATA_01 DATAFILE 
  '+DATA_1/adry/m_voa_data_01_01' SIZE 512M AUTOEXTEND ON NEXT 512M MAXSIZE 32767M
LOGGING
ONLINE
EXTENT MANAGEMENT LOCAL UNIFORM SIZE 4M
BLOCKSIZE 8K
SEGMENT SPACE MANAGEMENT AUTO
FLASHBACK ON;
DROP TABLESPACE M_VOA_INDEX_01 INCLUDING CONTENTS AND DATAFILES;

CREATE TABLESPACE M_VOA_INDEX_01 DATAFILE 
  '+INDEX_1/adry/m_voa_index_01_01' SIZE 512M AUTOEXTEND ON NEXT 512M MAXSIZE 32767M
LOGGING
ONLINE
EXTENT MANAGEMENT LOCAL UNIFORM SIZE 4M
BLOCKSIZE 8K
SEGMENT SPACE MANAGEMENT AUTO
FLASHBACK ON;
DROP TABLESPACE S_VOA_DATA_01 INCLUDING CONTENTS AND DATAFILES;

CREATE TABLESPACE S_VOA_DATA_01 DATAFILE 
  '+DATA_1/adry/s_voa_data_01_01' SIZE 512M AUTOEXTEND ON NEXT 512M MAXSIZE 32767M
LOGGING
ONLINE
EXTENT MANAGEMENT LOCAL UNIFORM SIZE 128K
BLOCKSIZE 8K
SEGMENT SPACE MANAGEMENT AUTO
FLASHBACK ON;
DROP TABLESPACE S_VOA_INDEX_01 INCLUDING CONTENTS AND DATAFILES;

CREATE TABLESPACE S_VOA_INDEX_01 DATAFILE 
  '+INDEX_1/adry/s_voa_index_01_01' SIZE 512M AUTOEXTEND ON NEXT 512M MAXSIZE 32767M
LOGGING
ONLINE
EXTENT MANAGEMENT LOCAL UNIFORM SIZE 128K
BLOCKSIZE 8K
SEGMENT SPACE MANAGEMENT AUTO
FLASHBACK ON;
DROP TABLESPACE M_ADRTMP_DATA_01 INCLUDING CONTENTS AND DATAFILES;

CREATE TABLESPACE M_ADRTMP_DATA_01 DATAFILE 
  '+DATA_1/adry/m_adrtmp_data_01_01' SIZE 4608M AUTOEXTEND ON NEXT 512M MAXSIZE 32767M
LOGGING
ONLINE
EXTENT MANAGEMENT LOCAL UNIFORM SIZE 4M
BLOCKSIZE 8K
SEGMENT SPACE MANAGEMENT AUTO
FLASHBACK ON;
DROP TABLESPACE M_ADRTMP_INDEX_01 INCLUDING CONTENTS AND DATAFILES;

CREATE TABLESPACE M_ADRTMP_INDEX_01 DATAFILE 
  '+INDEX_1/adry/m_adrtmp_index_01_01' SIZE 5G AUTOEXTEND ON NEXT 512M MAXSIZE 32767M
LOGGING
ONLINE
EXTENT MANAGEMENT LOCAL UNIFORM SIZE 4M
BLOCKSIZE 8K
SEGMENT SPACE MANAGEMENT AUTO
FLASHBACK ON;
DROP TABLESPACE M_ADHOC_DATA_01 INCLUDING CONTENTS AND DATAFILES;

CREATE TABLESPACE M_ADHOC_DATA_01 DATAFILE 
  '+DATA_1/adry/m_adhoc_data_01_01' SIZE 5G AUTOEXTEND ON NEXT 512M MAXSIZE 32767M
LOGGING
ONLINE
EXTENT MANAGEMENT LOCAL UNIFORM SIZE 4M
BLOCKSIZE 8K
SEGMENT SPACE MANAGEMENT AUTO
FLASHBACK ON;
DROP TABLESPACE S_ADRFILE_DATA_01 INCLUDING CONTENTS AND DATAFILES;

CREATE TABLESPACE S_ADRFILE_DATA_01 DATAFILE 
  '+DATA_1/adry/s_adrfile_data_01_01' SIZE 128M AUTOEXTEND ON NEXT 128M MAXSIZE 32767M
LOGGING
ONLINE
EXTENT MANAGEMENT LOCAL UNIFORM SIZE 128K
BLOCKSIZE 8K
SEGMENT SPACE MANAGEMENT AUTO
FLASHBACK ON;
DROP TABLESPACE S_ADRFILE_INDEX_01 INCLUDING CONTENTS AND DATAFILES;

CREATE TABLESPACE S_ADRFILE_INDEX_01 DATAFILE 
  '+INDEX_1/adry/s_adrfile_index_01_01' SIZE 128M AUTOEXTEND ON NEXT 128M MAXSIZE 32767M
LOGGING
ONLINE
EXTENT MANAGEMENT LOCAL UNIFORM SIZE 128K
BLOCKSIZE 8K
SEGMENT SPACE MANAGEMENT AUTO
FLASHBACK ON;
DROP TABLESPACE M_ADRFILE_DATA_01 INCLUDING CONTENTS AND DATAFILES;

CREATE TABLESPACE M_ADRFILE_DATA_01 DATAFILE 
  '+DATA_1/adry/m_adrfile_data_01_01' SIZE 128M AUTOEXTEND ON NEXT 128M MAXSIZE 32767M
LOGGING
ONLINE
EXTENT MANAGEMENT LOCAL UNIFORM SIZE 4M
BLOCKSIZE 8K
SEGMENT SPACE MANAGEMENT AUTO
FLASHBACK ON;
DROP TABLESPACE M_ADRFILE_INDEX_01 INCLUDING CONTENTS AND DATAFILES;

CREATE TABLESPACE M_ADRFILE_INDEX_01 DATAFILE 
  '+INDEX_1/adry/m_adrfile_index_01_01' SIZE 128M AUTOEXTEND ON NEXT 128M MAXSIZE 32767M
LOGGING
ONLINE
EXTENT MANAGEMENT LOCAL UNIFORM SIZE 4M
BLOCKSIZE 8K
SEGMENT SPACE MANAGEMENT AUTO
FLASHBACK ON;
DROP TABLESPACE S_VBR_DATA_01 INCLUDING CONTENTS AND DATAFILES;

CREATE TABLESPACE S_VBR_DATA_01 DATAFILE 
  '+DATA_1/adry/s_vbr_data_01_01' SIZE 128M AUTOEXTEND ON NEXT 128M MAXSIZE 32767M
LOGGING
ONLINE
EXTENT MANAGEMENT LOCAL UNIFORM SIZE 128K
BLOCKSIZE 8K
SEGMENT SPACE MANAGEMENT AUTO
FLASHBACK ON;
DROP TABLESPACE S_VBR_INDEX_01 INCLUDING CONTENTS AND DATAFILES;

CREATE TABLESPACE S_VBR_INDEX_01 DATAFILE 
  '+INDEX_1/adry/s_vbr_index_01_01' SIZE 128M AUTOEXTEND ON NEXT 128M MAXSIZE 32767M
LOGGING
ONLINE
EXTENT MANAGEMENT LOCAL UNIFORM SIZE 128K
BLOCKSIZE 8K
SEGMENT SPACE MANAGEMENT AUTO
FLASHBACK ON;
DROP TABLESPACE L_VBR_DATA_01 INCLUDING CONTENTS AND DATAFILES;

CREATE TABLESPACE L_VBR_DATA_01 DATAFILE 
  '+DATA_1/adry/l_vbr_data_01_01' SIZE 128M AUTOEXTEND ON NEXT 128M MAXSIZE 32767M
LOGGING
ONLINE
EXTENT MANAGEMENT LOCAL UNIFORM SIZE 4M
BLOCKSIZE 8K
SEGMENT SPACE MANAGEMENT AUTO
FLASHBACK ON;
DROP TABLESPACE L_VBR_INDEX_01 INCLUDING CONTENTS AND DATAFILES;

CREATE TABLESPACE L_VBR_INDEX_01 DATAFILE 
  '+INDEX_1/adry/l_vbr_index_01_01' SIZE 128M AUTOEXTEND ON NEXT 128M MAXSIZE 32767M
LOGGING
ONLINE
EXTENT MANAGEMENT LOCAL UNIFORM SIZE 4M
BLOCKSIZE 8K
SEGMENT SPACE MANAGEMENT AUTO
FLASHBACK ON;
DROP TABLESPACE L_DATA_03 INCLUDING CONTENTS AND DATAFILES;

CREATE TABLESPACE L_DATA_03 DATAFILE 
  '+DATA_2/adry/l_data_03_01' SIZE 31232M AUTOEXTEND ON NEXT 512M MAXSIZE 32767M,
  '+DATA_2/adry/l_data_03_02' SIZE 2G AUTOEXTEND ON NEXT 512M MAXSIZE 32767M
LOGGING
ONLINE
EXTENT MANAGEMENT LOCAL UNIFORM SIZE 128M
BLOCKSIZE 8K
SEGMENT SPACE MANAGEMENT AUTO
FLASHBACK ON;
DROP TABLESPACE L_INDEX_03 INCLUDING CONTENTS AND DATAFILES;

CREATE TABLESPACE L_INDEX_03 DATAFILE 
  '+INDEX_2/adry/l_index_03_01' SIZE 10752M AUTOEXTEND ON NEXT 512M MAXSIZE 32767M
LOGGING
ONLINE
EXTENT MANAGEMENT LOCAL UNIFORM SIZE 128M
BLOCKSIZE 8K
SEGMENT SPACE MANAGEMENT AUTO
FLASHBACK ON;
DROP TABLESPACE M_CIS_DATA_01 INCLUDING CONTENTS AND DATAFILES;

CREATE TABLESPACE M_CIS_DATA_01 DATAFILE 
  '+DATA_1/adry/m_cis_data_01_01' SIZE 5632M AUTOEXTEND ON NEXT 512M MAXSIZE 32767M
LOGGING
ONLINE
EXTENT MANAGEMENT LOCAL UNIFORM SIZE 128M
BLOCKSIZE 8K
SEGMENT SPACE MANAGEMENT AUTO
FLASHBACK ON;
DROP TABLESPACE M_CIS_INDEX_01 INCLUDING CONTENTS AND DATAFILES;

CREATE TABLESPACE M_CIS_INDEX_01 DATAFILE 
  '+INDEX_1/adry/m_cis_index_01_01' SIZE 12800M AUTOEXTEND ON NEXT 512M MAXSIZE 32767M
LOGGING
ONLINE
EXTENT MANAGEMENT LOCAL UNIFORM SIZE 128M
BLOCKSIZE 8K
SEGMENT SPACE MANAGEMENT AUTO
FLASHBACK ON;
DROP TABLESPACE L_CIS_DATA_01 INCLUDING CONTENTS AND DATAFILES;

CREATE TABLESPACE L_CIS_DATA_01 DATAFILE 
  '+DATA_1/adry/l_cis_data_01_01' SIZE 4G AUTOEXTEND ON NEXT 512M MAXSIZE 32767M
LOGGING
ONLINE
EXTENT MANAGEMENT LOCAL UNIFORM SIZE 128M
BLOCKSIZE 8K
SEGMENT SPACE MANAGEMENT AUTO
FLASHBACK ON;
DROP TABLESPACE L_CIS_INDEX_01 INCLUDING CONTENTS AND DATAFILES;

CREATE TABLESPACE L_CIS_INDEX_01 DATAFILE 
  '+INDEX_1/adry/l_cis_index_01_01' SIZE 4608M AUTOEXTEND ON NEXT 512M MAXSIZE 32767M
LOGGING
ONLINE
EXTENT MANAGEMENT LOCAL UNIFORM SIZE 128M
BLOCKSIZE 8K
SEGMENT SPACE MANAGEMENT AUTO
FLASHBACK ON;
DROP TABLESPACE M_BENS_DATA_01 INCLUDING CONTENTS AND DATAFILES;

CREATE TABLESPACE M_BENS_DATA_01 DATAFILE 
  '+DATA_1/adry/m_bens_data_01_01' SIZE 512M AUTOEXTEND ON NEXT 512M MAXSIZE 32767M
LOGGING
ONLINE
EXTENT MANAGEMENT LOCAL UNIFORM SIZE 128M
BLOCKSIZE 8K
SEGMENT SPACE MANAGEMENT AUTO
FLASHBACK ON;
DROP TABLESPACE M_BENS_INDEX_01 INCLUDING CONTENTS AND DATAFILES;

CREATE TABLESPACE M_BENS_INDEX_01 DATAFILE 
  '+INDEX_1/adry/m_bens_index_01_01' SIZE 512M AUTOEXTEND ON NEXT 512M MAXSIZE 32767M
LOGGING
ONLINE
EXTENT MANAGEMENT LOCAL UNIFORM SIZE 128M
BLOCKSIZE 8K
SEGMENT SPACE MANAGEMENT AUTO
FLASHBACK ON;
DROP TABLESPACE S_BENS_DATA_01 INCLUDING CONTENTS AND DATAFILES;

CREATE TABLESPACE S_BENS_DATA_01 DATAFILE 
  '+DATA_1/adry/s_bens_data_01_01' SIZE 512M AUTOEXTEND ON NEXT 512M MAXSIZE 32767M
LOGGING
ONLINE
EXTENT MANAGEMENT LOCAL UNIFORM SIZE 128M
BLOCKSIZE 8K
SEGMENT SPACE MANAGEMENT AUTO
FLASHBACK ON;
DROP TABLESPACE S_BENS_INDEX_01 INCLUDING CONTENTS AND DATAFILES;

CREATE TABLESPACE S_BENS_INDEX_01 DATAFILE 
  '+INDEX_1/adry/s_bens_index_01_01' SIZE 512M AUTOEXTEND ON NEXT 512M MAXSIZE 32767M
LOGGING
ONLINE
EXTENT MANAGEMENT LOCAL UNIFORM SIZE 128M
BLOCKSIZE 8K
SEGMENT SPACE MANAGEMENT AUTO
FLASHBACK ON;
DROP TABLESPACE L_LOBR_DATA_01 INCLUDING CONTENTS AND DATAFILES;

CREATE TABLESPACE L_LOBR_DATA_01 DATAFILE 
  '+DATA_3/adry/l_lobr_data_01_01' SIZE 1G AUTOEXTEND ON NEXT 512M MAXSIZE 32767M
LOGGING
ONLINE
EXTENT MANAGEMENT LOCAL UNIFORM SIZE 128M
BLOCKSIZE 8K
SEGMENT SPACE MANAGEMENT AUTO
FLASHBACK ON;
DROP TABLESPACE L_LOBR_INDEX_01 INCLUDING CONTENTS AND DATAFILES;

CREATE TABLESPACE L_LOBR_INDEX_01 DATAFILE 
  '+INDEX_3/adry/l_lobr_index_01_01' SIZE 1536M AUTOEXTEND ON NEXT 512M MAXSIZE 32767M
LOGGING
ONLINE
EXTENT MANAGEMENT LOCAL UNIFORM SIZE 128M
BLOCKSIZE 8K
SEGMENT SPACE MANAGEMENT AUTO
FLASHBACK ON;
DROP TABLESPACE S_ACA_DATA_01 INCLUDING CONTENTS AND DATAFILES;

CREATE TABLESPACE S_ACA_DATA_01 DATAFILE 
  '+DATA_1/adry/s_aca_data_01_01' SIZE 128M AUTOEXTEND ON NEXT 128M MAXSIZE 32767M
LOGGING
ONLINE
EXTENT MANAGEMENT LOCAL UNIFORM SIZE 128K
BLOCKSIZE 8K
SEGMENT SPACE MANAGEMENT AUTO
FLASHBACK ON;
DROP TABLESPACE S_ACA_INDEX_01 INCLUDING CONTENTS AND DATAFILES;

CREATE TABLESPACE S_ACA_INDEX_01 DATAFILE 
  '+INDEX_1/adry/s_aca_index_01_01' SIZE 128M AUTOEXTEND ON NEXT 128M MAXSIZE 32767M
LOGGING
ONLINE
EXTENT MANAGEMENT LOCAL UNIFORM SIZE 128K
BLOCKSIZE 8K
SEGMENT SPACE MANAGEMENT AUTO
FLASHBACK ON;
DROP TABLESPACE M_ACA_DATA_01 INCLUDING CONTENTS AND DATAFILES;

CREATE TABLESPACE M_ACA_DATA_01 DATAFILE 
  '+DATA_1/adry/m_aca_data_01_01' SIZE 4736M AUTOEXTEND ON NEXT 128M MAXSIZE 32767M
LOGGING
ONLINE
EXTENT MANAGEMENT LOCAL UNIFORM SIZE 4M
BLOCKSIZE 8K
SEGMENT SPACE MANAGEMENT AUTO
FLASHBACK ON;
DROP TABLESPACE M_ACA_INDEX_01 INCLUDING CONTENTS AND DATAFILES;

CREATE TABLESPACE M_ACA_INDEX_01 DATAFILE 
  '+INDEX_1/adry/m_aca_index_01_01' SIZE 3G AUTOEXTEND ON NEXT 128M MAXSIZE 32767M
LOGGING
ONLINE
EXTENT MANAGEMENT LOCAL UNIFORM SIZE 4M
BLOCKSIZE 8K
SEGMENT SPACE MANAGEMENT AUTO
FLASHBACK ON;
DROP TABLESPACE L_ACA_DATA_01 INCLUDING CONTENTS AND DATAFILES;

CREATE TABLESPACE L_ACA_DATA_01 DATAFILE 
  '+DATA_1/adry/l_aca_data_01_01' SIZE 128M AUTOEXTEND ON NEXT 128M MAXSIZE 32767M
LOGGING
ONLINE
EXTENT MANAGEMENT LOCAL UNIFORM SIZE 4M
BLOCKSIZE 8K
SEGMENT SPACE MANAGEMENT AUTO
FLASHBACK ON;
DROP TABLESPACE L_ACA_INDEX_01 INCLUDING CONTENTS AND DATAFILES;

CREATE TABLESPACE L_ACA_INDEX_01 DATAFILE 
  '+INDEX_1/adry/l_aca_index_01_01' SIZE 384M AUTOEXTEND ON NEXT 128M MAXSIZE 32767M
LOGGING
ONLINE
EXTENT MANAGEMENT LOCAL UNIFORM SIZE 4M
BLOCKSIZE 8K
SEGMENT SPACE MANAGEMENT AUTO
FLASHBACK ON;
DROP TABLESPACE L_PSIMLOG_DATA_01 INCLUDING CONTENTS AND DATAFILES;

CREATE TABLESPACE L_PSIMLOG_DATA_01 DATAFILE 
  '+DATA_2/adry/l_psimlog_data_01_01' SIZE 32767M AUTOEXTEND ON NEXT 128M MAXSIZE 32767M,
  '+DATA_2/adry/l_psimlog_data_01_02' SIZE 18944M AUTOEXTEND ON NEXT 512M MAXSIZE 32767M
LOGGING
ONLINE
EXTENT MANAGEMENT LOCAL UNIFORM SIZE 4M
BLOCKSIZE 8K
SEGMENT SPACE MANAGEMENT AUTO
FLASHBACK ON;
DROP TABLESPACE L_PSIMLOG_INDEX_01 INCLUDING CONTENTS AND DATAFILES;

CREATE TABLESPACE L_PSIMLOG_INDEX_01 DATAFILE 
  '+INDEX_2/adry/l_psimlog_index_01_01' SIZE 32256M AUTOEXTEND ON NEXT 128M MAXSIZE 32767M,
  '+INDEX_2/adry/l_psimlog_index_01_2' SIZE 6656M AUTOEXTEND ON NEXT 512M MAXSIZE 32767M
LOGGING
ONLINE
EXTENT MANAGEMENT LOCAL UNIFORM SIZE 4M
BLOCKSIZE 8K
SEGMENT SPACE MANAGEMENT AUTO
FLASHBACK ON;
DROP TABLESPACE M_ODM_DATA_01 INCLUDING CONTENTS AND DATAFILES;

CREATE TABLESPACE M_ODM_DATA_01 DATAFILE 
  '+DATA_1/adry/m_odm_data_01_01' SIZE 128M AUTOEXTEND ON NEXT 128M MAXSIZE 32767M
LOGGING
ONLINE
EXTENT MANAGEMENT LOCAL UNIFORM SIZE 4M
BLOCKSIZE 8K
SEGMENT SPACE MANAGEMENT AUTO
FLASHBACK ON;
DROP TABLESPACE M_ODM_INDEX_01 INCLUDING CONTENTS AND DATAFILES;

CREATE TABLESPACE M_ODM_INDEX_01 DATAFILE 
  '+INDEX_1/adry/m_odm_index_01_01' SIZE 128M AUTOEXTEND ON NEXT 128M MAXSIZE 32767M
LOGGING
ONLINE
EXTENT MANAGEMENT LOCAL UNIFORM SIZE 4M
BLOCKSIZE 8K
SEGMENT SPACE MANAGEMENT AUTO
FLASHBACK ON;
DROP TABLESPACE M_JRULE_DATA_01 INCLUDING CONTENTS AND DATAFILES;

CREATE TABLESPACE M_JRULE_DATA_01 DATAFILE 
  '+DATA_1/adry/m_jrule_data_01_01' SIZE 2560M AUTOEXTEND ON NEXT 512M MAXSIZE 32767M
LOGGING
ONLINE
EXTENT MANAGEMENT LOCAL UNIFORM SIZE 128M
BLOCKSIZE 8K
SEGMENT SPACE MANAGEMENT AUTO
FLASHBACK ON;
DROP TABLESPACE M_JRULE_INDEX_01 INCLUDING CONTENTS AND DATAFILES;

CREATE TABLESPACE M_JRULE_INDEX_01 DATAFILE 
  '+INDEX_1/adry/m_jrule_01_01' SIZE 2G AUTOEXTEND ON NEXT 512M MAXSIZE 32767M
LOGGING
ONLINE
EXTENT MANAGEMENT LOCAL UNIFORM SIZE 128M
BLOCKSIZE 8K
SEGMENT SPACE MANAGEMENT AUTO
FLASHBACK ON;
DROP TABLESPACE M_PATS_DATA_01 INCLUDING CONTENTS AND DATAFILES;

CREATE TABLESPACE M_PATS_DATA_01 DATAFILE 
  '+DATA_1/adry/m_pats_data_01_01' SIZE 256M AUTOEXTEND ON NEXT 128M MAXSIZE 32767M
LOGGING
ONLINE
EXTENT MANAGEMENT LOCAL UNIFORM SIZE 4M
BLOCKSIZE 8K
SEGMENT SPACE MANAGEMENT AUTO
FLASHBACK ON;
DROP TABLESPACE M_PATS_INDEX_01 INCLUDING CONTENTS AND DATAFILES;

CREATE TABLESPACE M_PATS_INDEX_01 DATAFILE 
  '+INDEX_1/adry/m_pats_index_01_01' SIZE 256M AUTOEXTEND ON NEXT 128M MAXSIZE 32767M
LOGGING
ONLINE
EXTENT MANAGEMENT LOCAL UNIFORM SIZE 4M
BLOCKSIZE 8K
SEGMENT SPACE MANAGEMENT AUTO
FLASHBACK ON;
DROP TABLESPACE M_PATSRPTS_DATA_01 INCLUDING CONTENTS AND DATAFILES;

CREATE TABLESPACE M_PATSRPTS_DATA_01 DATAFILE 
  '+DATA_1/adry/m_patsrpts_data_01_01' SIZE 128M AUTOEXTEND ON NEXT 128M MAXSIZE 32767M
LOGGING
ONLINE
EXTENT MANAGEMENT LOCAL UNIFORM SIZE 4M
BLOCKSIZE 8K
SEGMENT SPACE MANAGEMENT AUTO
FLASHBACK ON;
DROP TABLESPACE M_PATSRPTS_INDEX_01 INCLUDING CONTENTS AND DATAFILES;

CREATE TABLESPACE M_PATSRPTS_INDEX_01 DATAFILE 
  '+INDEX_1/adry/m_patsrpts_index_01_01' SIZE 128M AUTOEXTEND ON NEXT 128M MAXSIZE 32767M
LOGGING
ONLINE
EXTENT MANAGEMENT LOCAL UNIFORM SIZE 4M
BLOCKSIZE 8K
SEGMENT SPACE MANAGEMENT AUTO
FLASHBACK ON;
DROP TABLESPACE M_KAJEE_DATA_01 INCLUDING CONTENTS AND DATAFILES;

CREATE TABLESPACE M_KAJEE_DATA_01 DATAFILE 
  '+DATA_1/adry/m_kajee_data_01_01' SIZE 256M AUTOEXTEND ON NEXT 128M MAXSIZE 32767M
LOGGING
ONLINE
EXTENT MANAGEMENT LOCAL UNIFORM SIZE 4M
BLOCKSIZE 8K
SEGMENT SPACE MANAGEMENT AUTO
FLASHBACK ON;
DROP TABLESPACE L_CIS_LOB_01 INCLUDING CONTENTS AND DATAFILES;

CREATE TABLESPACE L_CIS_LOB_01 DATAFILE 
  '+DATA_1/adry/l_cis_lob_01_01' SIZE 1536M AUTOEXTEND ON NEXT 512M MAXSIZE 32767M
LOGGING
ONLINE
EXTENT MANAGEMENT LOCAL UNIFORM SIZE 128M
BLOCKSIZE 8K
SEGMENT SPACE MANAGEMENT AUTO
FLASHBACK ON;
DROP TABLESPACE M_QUARTZ_DATA_01 INCLUDING CONTENTS AND DATAFILES;

CREATE TABLESPACE M_QUARTZ_DATA_01 DATAFILE 
  '+DATA_1/adry/m_quartz_data_01_01' SIZE 512M AUTOEXTEND ON NEXT 512M MAXSIZE 32767M
LOGGING
ONLINE
EXTENT MANAGEMENT LOCAL UNIFORM SIZE 128M
BLOCKSIZE 8K
SEGMENT SPACE MANAGEMENT AUTO
FLASHBACK ON;
DROP TABLESPACE M_QUARTZ_INDEX_01 INCLUDING CONTENTS AND DATAFILES;

CREATE TABLESPACE M_QUARTZ_INDEX_01 DATAFILE 
  '+DATA_1/adry/m_quartz_index_01_01' SIZE 512M AUTOEXTEND ON NEXT 512M MAXSIZE 32767M
LOGGING
ONLINE
EXTENT MANAGEMENT LOCAL UNIFORM SIZE 128M
BLOCKSIZE 8K
SEGMENT SPACE MANAGEMENT AUTO
FLASHBACK ON;
DROP TABLESPACE L_CIS_DATA_02_P01 INCLUDING CONTENTS AND DATAFILES;

CREATE TABLESPACE L_CIS_DATA_02_P01 DATAFILE 
  '+DATA_1/adry/l_cis_data_02_p01_01' SIZE 512M AUTOEXTEND ON NEXT 512M MAXSIZE 32767M
LOGGING
ONLINE
EXTENT MANAGEMENT LOCAL UNIFORM SIZE 128M
BLOCKSIZE 8K
SEGMENT SPACE MANAGEMENT AUTO
FLASHBACK ON;
DROP TABLESPACE L_CIS_DATA_02_P02 INCLUDING CONTENTS AND DATAFILES;

CREATE TABLESPACE L_CIS_DATA_02_P02 DATAFILE 
  '+DATA_1/adry/l_cis_data_02_p02_01' SIZE 512M AUTOEXTEND ON NEXT 512M MAXSIZE 32767M
LOGGING
ONLINE
EXTENT MANAGEMENT LOCAL UNIFORM SIZE 128M
BLOCKSIZE 8K
SEGMENT SPACE MANAGEMENT AUTO
FLASHBACK ON;
DROP TABLESPACE L_CIS_DATA_02_P03 INCLUDING CONTENTS AND DATAFILES;

CREATE TABLESPACE L_CIS_DATA_02_P03 DATAFILE 
  '+DATA_1/adry/l_cis_data_02_p03_01' SIZE 512M AUTOEXTEND ON NEXT 512M MAXSIZE 32767M
LOGGING
ONLINE
EXTENT MANAGEMENT LOCAL UNIFORM SIZE 128M
BLOCKSIZE 8K
SEGMENT SPACE MANAGEMENT AUTO
FLASHBACK ON;
DROP TABLESPACE L_CIS_DATA_02_P04 INCLUDING CONTENTS AND DATAFILES;

CREATE TABLESPACE L_CIS_DATA_02_P04 DATAFILE 
  '+DATA_1/adry/l_cis_data_02_p04_01' SIZE 512M AUTOEXTEND ON NEXT 512M MAXSIZE 32767M
LOGGING
ONLINE
EXTENT MANAGEMENT LOCAL UNIFORM SIZE 128M
BLOCKSIZE 8K
SEGMENT SPACE MANAGEMENT AUTO
FLASHBACK ON;
DROP TABLESPACE L_CIS_INDEX_02_P01 INCLUDING CONTENTS AND DATAFILES;

CREATE TABLESPACE L_CIS_INDEX_02_P01 DATAFILE 
  '+DATA_1/adry/l_cis_index_02_p01_01' SIZE 1G AUTOEXTEND ON NEXT 512M MAXSIZE 32767M
LOGGING
ONLINE
EXTENT MANAGEMENT LOCAL UNIFORM SIZE 128M
BLOCKSIZE 8K
SEGMENT SPACE MANAGEMENT AUTO
FLASHBACK ON;
DROP TABLESPACE L_CIS_INDEX_02_P02 INCLUDING CONTENTS AND DATAFILES;

CREATE TABLESPACE L_CIS_INDEX_02_P02 DATAFILE 
  '+DATA_1/adry/l_cis_index_02_p02_01' SIZE 1G AUTOEXTEND ON NEXT 512M MAXSIZE 32767M
LOGGING
ONLINE
EXTENT MANAGEMENT LOCAL UNIFORM SIZE 128M
BLOCKSIZE 8K
SEGMENT SPACE MANAGEMENT AUTO
FLASHBACK ON;
DROP TABLESPACE L_CIS_INDEX_02_P03 INCLUDING CONTENTS AND DATAFILES;

CREATE TABLESPACE L_CIS_INDEX_02_P03 DATAFILE 
  '+DATA_1/adry/l_cis_index_02_p03_01' SIZE 1G AUTOEXTEND ON NEXT 512M MAXSIZE 32767M
LOGGING
ONLINE
EXTENT MANAGEMENT LOCAL UNIFORM SIZE 128M
BLOCKSIZE 8K
SEGMENT SPACE MANAGEMENT AUTO
FLASHBACK ON;
DROP TABLESPACE L_CIS_INDEX_02_P04 INCLUDING CONTENTS AND DATAFILES;

CREATE TABLESPACE L_CIS_INDEX_02_P04 DATAFILE 
  '+DATA_1/adry/l_cis_index_02_p04_01' SIZE 1G AUTOEXTEND ON NEXT 512M MAXSIZE 32767M
LOGGING
ONLINE
EXTENT MANAGEMENT LOCAL UNIFORM SIZE 128M
BLOCKSIZE 8K
SEGMENT SPACE MANAGEMENT AUTO
FLASHBACK ON;
